#ifndef ZMODELER_STRUCT_UNDO_H_INCLUDED
#define ZMODELER_STRUCT_UNDO_H_INCLUDED

//////////////////////////////////////////////////
//    UNDO is the Stack of operations.
struct tDefaultUndoBlock
{
  WORD    id;         //ID of undo procedure
  WORD    conditions;
  long    entries;    //amount of records (of objects/vertices/faces...)
  DWORD*  flags;      //[entries]
  void*   pointers;   //[entries] - array of pointers to any other data.
  DllExport tDefaultUndoBlock();
};

struct tUndoBlock
{
  char*               ProcName;
  PLUGUNDOPROC        UndoProc;
  PLUGPTRASPARAMPROC  ReleaseProc;
  PLUGPTRASPARAMPROC  CreateRedoProc;
  struct Params
  {
    UINT              nFlags;
    POINT             loc;
    tPOINT            ProcessedLocation;
    tPOINT            LastMovedAt;
    tPOINT            LastPressedAt;
    float             ApplyX;
    float             ApplyY;
    z3dViewDescriptor ViewDesc;
    void*             pDATA;
    DWORD             nDataFlags;
    DWORD             reserv; //future capability
    long              SplineOperands[MAX_SPLINE_OPERANDS];
    long              ObjOperands[MAX_OBJ_OPERANDS];
  }Params;
  tDefaultUndoBlock*  UndoBuffer;
};

struct tStackBlock
{
  tUndoBlock    Block;
  tStackBlock*  Next;
};

typedef tStackBlock*  tStackItem;




///////////////////////////////////////////////////////////
//  The object of Stack that performs the Undo and other
class DllExport tUndoStack
{
  tStackItem  pHead;
  tStackItem  pUndo;//if differs from pHead, then there is a REDO section
public:
  tUndoStack();
  ~tUndoStack();
  
  void        ReleaseBuffers();
  void        ReleaseTopBlock();//if you don't need it anymore
  BOOL        IsEmpty()  {return pUndo == NULL;  }
  tStackItem  GetItem()  {return pUndo;      }
  tStackItem  GetTop()  {return pHead;      }
  char*       GetUndoName(); //NULL if none
  char*       GetRedoName(); //NULL if none
  tDefaultUndoBlock*  GetTopBlock();
  DWORD       PerformUndo(tProcParams* params);
  DWORD       PerformRedo(tProcParams* params);
  void        Add(const char*         pName,
                  PLUGUNDOPROC        ProcAddr,
                  PLUGPTRASPARAMPROC  ReleaseProc,
                  PLUGPTRASPARAMPROC  CreateRedoProc,
                  tDefaultUndoBlock*  Buffer);
};

/******************************************************************/
//  Some Undo types
/******************************************************************/

//////////////////////////
// Move, Scale.
struct CoordBlock
{
  float X;
  float Y;
  float Z;
};

//////////////////////////
// all normals functions:
struct NormalsBlock
{
  float normX;
  float normY;
  float normZ;
};

//////////////////////////
// rotate
struct CoordNormBlock
{
  float X;
  float Y;
  float Z;
  float normX;
  float normY;
  float normZ;
};


//////////////////////////
// Mapping
struct UVBlock
{
  long material;
  float U1,U2,U3,V1,V2,V3;
};

//////////////////////////
// Faces indexes
struct IndexBlock
{
  long I1,I2,I3;
};


//////////////////////////
// Mesh Backup:
struct MeshBlock
{
  tNormalVertex  *VertTable; //array
  tFace          *FaceTable; //array
  long          VertAmount;
  long          FaceAmount;
  tMATRIX       transform;
  MeshBlock()
  {
    VertTable = NULL;
    FaceTable = NULL;
    VertAmount= 0;
    FaceAmount= 0;
  }
  ~MeshBlock()
  {
    if (VertTable && (VertAmount>0)) delete[] VertTable;
    if (FaceTable && (FaceAmount>0)) delete[] FaceTable;
    VertTable = 0;
    FaceTable = 0;
  }
};


//////////////////////////
// MapperObject (or any other single object) Backup:
struct MapperObject
{
  tObject      *Mapper;
  long      position; //-1 if no mapper object
  MapperObject()
  {
    Mapper = NULL;
    position = -1;
  }
  ~MapperObject()
  {
    if (Mapper && (position >= 0)) delete Mapper;
    Mapper = NULL;
  }
};



/*******************************************************************
********************************************************************
        STANDART BACKUP ROUTINES
********************************************************************
*******************************************************************/
DllExport void Backup(sBackupType BackType, const char* name, BOOL bMapperTo, tProcParams *params);
DllExport BOOL IsValidUndoBlock(tDefaultUndoBlock* buffer, DWORD expected);

DllExport MapperObject* BackupObjectMesh(tProcParams *params, long index);
DllExport void RestoreObjectMesh(tProcParams *params, MapperObject* MapObj);
DllExport DWORD CALLBACK ReleaseMeshBuffer(tDefaultUndoBlock *buffer);

DllExport DWORD*    CreateObjectsFlags(tProcParams *params);

#endif

